// (0) -------------------------------------------------------------------------------
// Preliminaries
#declare R       = seed(10);
#declare Target  = object {Floor}	//fill in here the correct name
#declare MinEx   = min_extent(Target);
#declare MaxEx   = max_extent(Target);
#declare TestBox = box {<MinEx.x, 100, MinEx.z>, <MaxEx.x, 101, MaxEx.z>} // A test box where the random points will be generated
#declare Write   = off; // set off/on
#declare Num     = 600; // number of objects to trace
 
// (1) -------------------------------------------------------------------------------
// Based originally on code by Kirk Andrews (LandscapeTutorial.pov)
// ================================================================
//  This is a simple Proximity Function.
//  To be used for many things in a landscape scene.

#declare ProxF =
function {
  pigment {
    average
    pigment_map { 
      #local Counter = 0;
      #while (Counter < 50)
        [   
          // The object pattern, using the terrain.
          object {            
            object {Target
              translate <rand(R)-0.5, rand(R)-0.5, rand(R)-0.5>*rand(R)
            }
            color rgb 0,      // outside object
            color rgb 1       // inside object  
          } 
        ]                                                
        #local Counter = Counter+1;
      #end	//while
    }	//pigment_map
  }	//pigment
}	//function

#declare ObjF =
function {
  pattern {
    bumps
    turbulence 0.1
    scale 1.0 			//scale up or down according to need
  }
}

// (2) -------------------------------------------------------------------------------
// writing random locations to file:
#declare Counter = 0; 

#if (Write)
  #debug "   writing object locations...\n"
  #fopen ObjLocs "ObjLocs.inc" write

  #while (Counter <= Num)
    // (2.1) Random location 
    #declare Norm  = <0, 0, 0>;
    #declare Start = VRand_In_Obj(TestBox, R);
    #declare Pos   = trace (Target, Start, -y, Norm);   
    
    // (2.2) Testing presence (change if necessary)                                                       
    //#declare Visible = IsObjectVisible(Pos)
    //#if (Visible)
      //#if (
         //Pos.y >= 16.0
         //& Pos.y > .01*MaxY                           //  Altitude controls:  Minimum
         //&Pos.y < (.5+rand(R)*.4)*MaxY                //     "         "   :  Maximum, with a little feathering
     //    vdot(Norm, y) > 0.8                          //  Limit the slope on which objects can be;  vdot is a dot product function.
     //    & ObjF(Pos.x,Pos.y,Pos.z) < 0.5+rand(R)*.1   //  I use a function to gather objects together, while some bare spots remain.  The rand() helps feather the edges. 
     //    & ProxF(Pos.x,Pos.y,Pos.z).red > 0.45        //  Here's that proximty function again.  No objects on sharp edges.  
     //   )
    
        // (2.3) Writing the locations (last line test)
        #if (Counter = Num)
          #write (ObjLocs,Pos,", ",Norm,"\n")
        #else
          #write (ObjLocs,Pos,", ",Norm,",\n")
        #end

        // (2.4) Just a little code to let me know how the posing is coming:
        #if (mod(Counter, Num/10) = 0)    
          #debug concat("   Objects: ", str(Counter,5,0), "\n") 
        #end 
     
        #local Counter = Counter + 1;  // The counter only ticks if an object is actually posed. 
   //   #end	//of if conditions
   // #end	//of if Visible
  #end	//of while loop

  #fclose ObjLocs

#end	//of Write

// (3) -------------------------------------------------------------------------------
// Reading object locations:
#debug "   reading object locations...\n"

#declare SampleObj =
sphere { 
  <0,0.9,0>, 1 
}

#fopen ObjLocs "ObjLocs.inc" read
#declare Counter = 0;

union {
  #while (defined(ObjLocs))
    #read (ObjLocs, Pos, Norm)
    
    #declare Counter = Counter + 1;
    // Just a little code to let me know how the posing is coming:
    #if (mod(Counter, Num/10) = 0)    
      #debug concat("   Objects: ", str(Counter,5,0), "\n") 
    #end 
     
    object {
      SampleObj
           
      // The following tranformations are all about increasing the perceived variety of objects/trees in the scene:        
      //translate -rand(R)*.3*y                                             // This trick will work as long as your camera isn't too close. It adds to the perceived variety of objects.
      //scale 0.01                                                             // POV-Trees are 1 unit tall.  You'll have to figure out how tall your objects should be in your scene.
      //scale <0.5+rand(R), 0.5+ObjF(Pos.x,Pos.y,Pos.z)*2, 0.5+rand(R)>     // scale variation 1
      //scale <1, 0.5+ObjF(Pos.x,Pos.y,Pos.z)*2, 1>                         // scale variation 2
      scale 0.3 + ObjF(Pos.x,Pos.y,Pos.z)*2                               // scale variation 3
      //#if (rand(R) > .5) scale <-1, 1, 1> #end                            // Flip some objects 
      //scale <1, 1+ProxF(Pos.x,Pos.y,Pos.z).red, 1>                        // objects/trees in ditches can be taller. The ProxF function should provide a decent approximation.
      //rotate rand(R)*4*x
      //rotate rand(R)*360*y
      //Reorient_Trans(y, Norm)
      translate Pos                             // and finally, pose it!
    }   
             
  #end	//of while defined

}	//end of union

#debug "Done.\n\n"

